import json
import numpy as np

def save_dict_to_json(data, filename):
    # Convert NumPy arrays to lists
    def convert_arrays(obj):
        if isinstance(obj, np.ndarray):
            return obj.tolist()
        if isinstance(obj, dict):
            return {k: convert_arrays(v) for k, v in obj.items()}
        return obj
    # Convert the dictionary
    json_serializable_data = convert_arrays(data)
    # Save to a JSON file
    with open(filename, 'w') as json_file:
        json.dump(json_serializable_data, json_file, indent=4)


# Convert to JSON-serializable format (handle float16 and other numpy dtypes)
def convert_to_json_serializable(obj):
    if isinstance(obj, np.ndarray):
        return obj.astype(float).tolist()
    elif isinstance(obj, (np.float16, np.float32, np.float64)):
        return float(obj)
    elif isinstance(obj, (np.int8, np.int16, np.int32, np.int64)):
        return int(obj)
    elif isinstance(obj, list):
        return [convert_to_json_serializable(item) for item in obj]
    else:
        return obj
